!Object constantsFor: 'Geos Libraries'!

geosLIB72 'SYSTEM\spool'! !

!Object constantsFor: 'Geos vardata'!

tempPageSizeControlMaxDimensions 27648!
attrPageSizeControlUiChanges 27652!
tempPrintControlInstance 27648!
attrPrintControlAppUi 27652!
tempPrintCompletionEvent 27656!
tempPrintControlAddressControl 27660!
!

!Object constantsFor: 'Geos messages'!

setPageSize 27648!
getPageSize 27649!
requestPageSizeMoniker 27650!
setPageType 27651!
setPageSizeEntry 27652!
setPageWidth 27653!
setPageHeight 27654!
setPaperOrientation 27655!
setEnvelopeOrientation 27656!
setLabelColumns 27657!
setLabelRows 27658!
setMarginLeft 27659!
setMarginTop 27660!
setMarginRight 27661!
setMarginBottom 27662!
setMaximumWidth 27663!
setMaximumHeight 27664!
controlInitiatePrint 27648!
controlPrint 27649!
controlVerifyCompleted 27650!
controlSetDocName 27651!
controlReportProgress 27652!
controlReportString 27652!
controlPrintingCancelled 27653!
controlPrintingCompleted 27654!
controlSetAttrs 27655!
controlGetAttrs 27656!
controlSetTotalPageRange 27657!
controlGetTotalPageRange 27658!
controlSetSelectedPageRange 27659!
controlGetSelectedPageRange 27660!
controlSetDocSize 27661!
controlGetDocSize 27662!
controlSetExtendedDocSize 27663!
controlGetExtendedDocSize 27664!
controlSetDocMargins 27665!
controlGetDocMargins 27666!
controlSetDocSizeInfo 27667!
controlGetDocSizeInfo 27668!
controlSetOutput 27669!
controlGetOutput 27670!
controlSetDocNameOutput 27671!
controlGetDocNameOutput 27672!
controlSetDefaultPrinter 27673!
controlGetDefaultPrinter 27674!
controlGetPrintMode 27675!
controlGetPaperSizeInfo 27676!
controlGetPaperSize 27677!
controlGetPrinterMargins 27678!
controlCalcDocDimensions 27679!
controlCheckIfDocWillFit 27680!
controlVerifyPrint 27681!
controlVerifyScale 27682!
controlVerifyCancel 27683!
controlAbortPrintJob 27684!
controlInitiateOutputUi 27685!
setPrintControlPageSize 27686!
getMailboxObjectType 27687!
cannotPrint 27688!
getFirstPageOffset 27689!
setPrintHeaderOption 27690!
!

!Geos class methodsFor: 'library calls'!

SpoolGetDefaultPageSizeInfo: psr
	"void pascal SpoolGetDefaultPageSizeInfo(PageSizeReport *psr) in spool.goh"
	^GEOS call: psr with: #[72 0 34 3 0]!

SpoolSetDefaultPageSizeInfo: psr
	"void pascal SpoolSetDefaultPageSizeInfo(PageSizeReport *psr) in spool.goh"
	^GEOS call: psr with: #[72 0 35 3 0]!

SpoolGetNumPaperSizes: sizesInfo with: pageType
	"void pascal SpoolGetNumPaperSizes(NumPaperSizesInfo *sizesInfo, PageType pageType) in spool.goh"
	^GEOS call: sizesInfo with: pageType with: #[72 0 36 3 1 0]!

SpoolGetPaperString: stringBuf with: paperSizeNum with: pageType
	"word pascal SpoolGetPaperString(char *stringBuf, word paperSizeNum, PageType pageType) in spool.goh"
	^GEOS call: stringBuf with: paperSizeNum with: pageType with: #[72 0 37 3 1 1 1]!

SpoolGetPaperSize: sizeInfo with: paperSizeNum with: pageType
	"void pascal SpoolGetPaperSize(PaperSizeInfo *sizeInfo, word paperSizeNum, PageType pageType) in spool.goh"
	^GEOS call: sizeInfo with: paperSizeNum with: pageType with: #[72 0 38 3 1 1 0]!

SpoolConvertPaperSize: width with: height with: pageType
	"word pascal SpoolConvertPaperSize(word width, word height, PageType pageType) in spool.goh"
	^GEOS call: width with: height with: pageType with: #[72 0 39 1 1 1 1]!

SpoolGetPaperSizeOrder: orderBuf with: userDefBuf with: numBuf with: pageType
	"void pascal SpoolGetPaperSizeOrder(byte *orderBuf, byte *userDefBuf, PaperSizeOrderInfo *numBuf, PageType pageType) in spool.goh"
	^GEOS call: orderBuf with: userDefBuf with: numBuf with: pageType with: #[72 0 40 3 3 3 1 0]!

SpoolSetPaperSizeOrder: orderArray with: numEntries with: pageType
	"void pascal SpoolSetPaperSizeOrder(byte *orderArray, word numEntries, PageType pageType) in spool.goh"
	^GEOS call: orderArray with: numEntries with: pageType with: #[72 0 41 3 1 1 0]!

SpoolCreatePaperSize: paperSizeString with: width with: height with: layout with: pageType
	"word pascal SpoolCreatePaperSize(char *paperSizeString, word width, word height, PageLayout layout, PageType pageType) in spool.goh"
	^GEOS call: paperSizeString with: width with: height with: layout with: pageType with: #[72 0 42 3 1 1 1 1 1]!

SpoolDeletePaperSize: paperSizeNum with: pageType
	"Boolean pascal SpoolDeletePaperSize(word paperSizeNum, PageType pageType) in spool.goh"
	^GEOS call: paperSizeNum with: pageType with: #[72 0 43 1 1 4]!

SpoolGetNumPrinters: driverType with: localOnlyFlag
	"word pascal SpoolGetNumPrinters(PrinterDriverType driverType, byte localOnlyFlag) in spool.goh"
	^GEOS call: driverType with: localOnlyFlag with: #[72 0 44 1 1 1]!

SpoolGetPrinterString: retInfo with: printerNum
	"Boolean pascal SpoolGetPrinterString(PrinterStringInfo *retInfo, word printerNum) in spool.goh"
	^GEOS call: retInfo with: printerNum with: #[72 0 45 3 1 4]!

SpoolCreatePrinter: printerName with: driverType
	"word pascal SpoolCreatePrinter(char *printerName, PrinterDriverType driverType) in spool.goh"
	^GEOS call: printerName with: driverType with: #[72 0 46 3 1 1]!

SpoolDeletePrinter: printerNum
	"void pascal SpoolDeletePrinter(word printerNum) in spool.goh"
	^GEOS call: printerNum with: #[72 0 47 1 0]!

SpoolGetDefaultPrinter
	"int pascal SpoolGetDefaultPrinter(void) in spool.goh"
	^GEOS call: #[72 0 18 4]!

SpoolSetDefaultPrinter: printerNum
	"void pascal SpoolSetDefaultPrinter(word printerNum) in spool.goh"
	^GEOS call: printerNum with: #[72 0 48 1 0]!

SpoolCreateSpoolFile: fileNameBuf
	"FileHandle pascal SpoolCreateSpoolFile(char *fileNameBuf) in spool.goh"
	^GEOS call: fileNameBuf with: #[72 0 49 3 1]!

SpoolDelJob: jobID
	"SpoolOpStatus pascal SpoolDelJob(word jobID) in spool.goh"
	^GEOS call: jobID with: #[72 0 50 1 1]!

SpoolInfo: infoType with: params
	"SpoolOpStatus pascal SpoolInfo(SpoolInfoType infoType, SpoolInfoParams *params) in spool.goh"
	^GEOS call: infoType with: params with: #[72 0 51 1 3 1]!

SpoolHurryJob: jobID
	"SpoolOpStatus pascal SpoolHurryJob(word jobID) in spool.goh"
	^GEOS call: jobID with: #[72 0 52 1 1]!

SpoolDelayJob: jobID
	"SpoolOpStatus pascal SpoolDelayJob(word jobID) in spool.goh"
	^GEOS call: jobID with: #[72 0 53 1 1]!

SpoolModifyPriority: jobID with: priority
	"SpoolOpStatus pascal SpoolModifyPriority(word jobID, ThreadPriority priority) in spool.goh"
	^GEOS call: jobID with: priority with: #[72 0 54 1 1 1]!

SpoolVerifyPrinterPort: portInfo
	"SpoolOpStatus pascal SpoolVerifyPrinterPort(struct _PrintPortInfo *portInfo) in spool.goh"
	^GEOS call: portInfo with: #[72 0 55 3 1]!

SpoolSetDocSize: openFlag with: psr
	"void pascal SpoolSetDocSize(Boolean openFlag, PageSizeReport *psr) in spool.goh"
	^GEOS call: openFlag with: psr with: #[72 0 31 4 3 0]!

!

GenControl subclass: #PageSizeControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #PrintControl
	instanceVariableNames: ''
	classVariableNames: ''!

!PageSizeControl comment!
Library spool, file spool.goh! !

!PageSizeControl class methodsFor: 'library linkage'!

library
	^72!

entry
	^4!
!

!PageSizeControl methodsFor: 'Geos instance variables'!

pzciAttrs
	"@instance PageSizeCtrlAttrs PZCI_attrs"
	^self wordAt: 25!

pzciAttrs: value
	"@instance PageSizeCtrlAttrs PZCI_attrs"
	^self wordAt: 25 put: value!

pzciWidth
	"@instance dword PZCI_width"
	^self dwordAt: 27!

pzciWidth: value
	"@instance dword PZCI_width"
	^self dwordAt: 27 put: value!

pzciHeight
	"@instance dword PZCI_height"
	^self dwordAt: 31!

pzciHeight: value
	"@instance dword PZCI_height"
	^self dwordAt: 31 put: value!

pzciLayout
	"@instance PageLayout PZCI_layout"
	^self wordAt: 35!

pzciLayout: value
	"@instance PageLayout PZCI_layout"
	^self wordAt: 35 put: value!

pzciMargins
	"@instance PCMarginParams PZCI_margins"
	^GCSPCMarginParams forPointer: (self ptrAt: 37).!

pzciMargins: aBlock
	"@instance PCMarginParams PZCI_margins"
	aBlock value: (GCSPCMarginParams forPointer: (self ptrAt: 37)).!

!

!PageSizeControl methodsFor: 'Geos vardata'!

tempPageSizeControlMaxDimensions
	"@vardata PageSizeControlMaxDimensions TEMP_PAGE_SIZE_CONTROL_MAX_DIMENSIONS"
	^self addVardata: ##tempPageSizeControlMaxDimensions size: 8!

tempPageSizeControlMaxDimensions: aBlock
	"@vardata PageSizeControlMaxDimensions TEMP_PAGE_SIZE_CONTROL_MAX_DIMENSIONS"
	aBlock value: (GCSPageSizeControlMaxDimensions forPointer: (self addVardata: ##tempPageSizeControlMaxDimensions size: 8)).!

attrPageSizeControlUiChanges
	"@vardata PageSizeControlChanges ATTR_PAGE_SIZE_CONTROL_UI_CHANGES"
	^self addVardata: ##attrPageSizeControlUiChanges size: 6!

attrPageSizeControlUiChanges: aBlock
	"@vardata PageSizeControlChanges ATTR_PAGE_SIZE_CONTROL_UI_CHANGES"
	aBlock value: (GCSPageSizeControlChanges forPointer: (self addVardata: ##attrPageSizeControlUiChanges size: 6)).!

!

!PageSizeControl methodsFor: 'Geos messages'!

setPageSize: psr
	"@message void MSG_PZC_SET_PAGE_SIZE( PageSizeReport *psr = dx:bp )"
	^self geosMessage: #[108 0 2 62 3 0] with: psr!

getPageSize: psr
	"@message void MSG_PZC_GET_PAGE_SIZE( PageSizeReport *psr = dx:bp )"
	^self geosMessage: #[108 1 2 62 3 0] with: psr!

requestPageSizeMoniker
	"@message void MSG_PZC_REQUEST_PAGE_SIZE_MONIKER()"
	^self geosMessage: #[108 2 2 0 0]!

setPageType
	"@message void MSG_PZC_SET_PAGE_TYPE()"
	^self geosMessage: #[108 3 2 0 0]!

setPageSizeEntry
	"@message void MSG_PZC_SET_PAGE_SIZE_ENTRY()"
	^self geosMessage: #[108 4 2 0 0]!

setPageWidth
	"@message void MSG_PZC_SET_PAGE_WIDTH()"
	^self geosMessage: #[108 5 2 0 0]!

setPageHeight
	"@message void MSG_PZC_SET_PAGE_HEIGHT()"
	^self geosMessage: #[108 6 2 0 0]!

setPaperOrientation
	"@message void MSG_PZC_SET_PAPER_ORIENTATION()"
	^self geosMessage: #[108 7 2 0 0]!

setEnvelopeOrientation
	"@message void MSG_PZC_SET_ENVELOPE_ORIENTATION()"
	^self geosMessage: #[108 8 2 0 0]!

setLabelColumns
	"@message void MSG_PZC_SET_LABEL_COLUMNS()"
	^self geosMessage: #[108 9 2 0 0]!

setLabelRows
	"@message void MSG_PZC_SET_LABEL_ROWS()"
	^self geosMessage: #[108 10 2 0 0]!

setMarginLeft
	"@message void MSG_PZC_SET_MARGIN_LEFT()"
	^self geosMessage: #[108 11 2 0 0]!

setMarginTop
	"@message void MSG_PZC_SET_MARGIN_TOP()"
	^self geosMessage: #[108 12 2 0 0]!

setMarginRight
	"@message void MSG_PZC_SET_MARGIN_RIGHT()"
	^self geosMessage: #[108 13 2 0 0]!

setMarginBottom
	"@message void MSG_PZC_SET_MARGIN_BOTTOM()"
	^self geosMessage: #[108 14 2 0 0]!

setMaximumWidth: width
	"@message void MSG_PZC_SET_MAXIMUM_WIDTH(dword width = dx.cx)"
	^self geosMessage: #[108 15 2 46 2 0] with: width!

setMaximumHeight: height
	"@message void MSG_PZC_SET_MAXIMUM_HEIGHT(dword height = dx.cx)"
	^self geosMessage: #[108 16 2 46 2 0] with: height!

!

!PrintControl comment!
Library spool, file spool.goh! !

!PrintControl class methodsFor: 'library linkage'!

library
	^72!

entry
	^0!
!

!PrintControl methodsFor: 'Geos instance variables'!

pciAttrs
	"@instance PrintControlAttrs PCI_attrs"
	^self wordAt: 25!

pciAttrs: value
	"@instance PrintControlAttrs PCI_attrs"
	^self wordAt: 25 put: value!

pciStartPage
	"@instance word PCI_startPage"
	^self wordAt: 27!

pciStartPage: value
	"@instance word PCI_startPage"
	^self wordAt: 27 put: value!

pciEndPage
	"@instance word PCI_endPage"
	^self wordAt: 29!

pciEndPage: value
	"@instance word PCI_endPage"
	^self wordAt: 29 put: value!

pciStartUserPage
	"@instance word PCI_startUserPage"
	^self wordAt: 31!

pciStartUserPage: value
	"@instance word PCI_startUserPage"
	^self wordAt: 31 put: value!

pciEndUserPage
	"@instance word PCI_endUserPage"
	^self wordAt: 33!

pciEndUserPage: value
	"@instance word PCI_endUserPage"
	^self wordAt: 33 put: value!

pciDefPrinter
	"@instance word PCI_defPrinter"
	^self wordAt: 35!

pciDefPrinter: value
	"@instance word PCI_defPrinter"
	^self wordAt: 35 put: value!

pciDocSizeInfo
	"@instance PageSizeReport PCI_docSizeInfo"
	^GCSPageSizeReport forPointer: (self ptrAt: 37).!

pciDocSizeInfo: aBlock
	"@instance PageSizeReport PCI_docSizeInfo"
	aBlock value: (GCSPageSizeReport forPointer: (self ptrAt: 37)).!

pciOutput
	"@instance optr PCI_output"
	^self dwordAt: 55!

pciOutput: value
	"@instance optr PCI_output"
	^self dwordAt: 55 put: value!

pciDocNameOutput
	"@instance optr PCI_docNameOutput"
	^self dwordAt: 59!

pciDocNameOutput: value
	"@instance optr PCI_docNameOutput"
	^self dwordAt: 59 put: value!

!

!PrintControl methodsFor: 'Geos vardata'!

tempPrintControlInstance
	"@vardata TempPrintCtrlInstance TEMP_PRINT_CONTROL_INSTANCE"
	^self addVardata: ##tempPrintControlInstance size: 20!

tempPrintControlInstance: aBlock
	"@vardata TempPrintCtrlInstance TEMP_PRINT_CONTROL_INSTANCE"
	aBlock value: (GCSTempPrintCtrlInstance forPointer: (self addVardata: ##tempPrintControlInstance size: 20)).!

attrPrintControlAppUi: value
	"@vardata optr ATTR_PRINT_CONTROL_APP_UI"
	^self addVardata: ##attrPrintControlAppUi dword: value!

tempPrintCompletionEvent
	"@vardata TempPrintCompletionEventData TEMP_PRINT_COMPLETION_EVENT"
	^self addVardata: ##tempPrintCompletionEvent size: 4!

tempPrintCompletionEvent: aBlock
	"@vardata TempPrintCompletionEventData TEMP_PRINT_COMPLETION_EVENT"
	aBlock value: (GCSTempPrintCompletionEventData forPointer: (self addVardata: ##tempPrintCompletionEvent size: 4)).!

tempPrintControlAddressControl
	"@vardata TempPrintAddressControlData TEMP_PRINT_CONTROL_ADDRESS_CONTROL"
	^self addVardata: ##tempPrintControlAddressControl size: 5!

tempPrintControlAddressControl: aBlock
	"@vardata TempPrintAddressControlData TEMP_PRINT_CONTROL_ADDRESS_CONTROL"
	aBlock value: (GCSTempPrintAddressControlData forPointer: (self addVardata: ##tempPrintControlAddressControl size: 5)).!

!

!PrintControl methodsFor: 'Geos messages'!

controlInitiatePrint
	"@message void MSG_PRINT_CONTROL_INITIATE_PRINT()"
	^self geosMessage: #[108 0 2 0 0]!

controlPrint
	"@message void MSG_PRINT_CONTROL_PRINT()"
	^self geosMessage: #[108 1 2 0 0]!

controlVerifyCompleted: continue
	"@message void MSG_PRINT_CONTROL_VERIFY_COMPLETED( Boolean continue = cx)"
	^self geosMessage: #[108 2 2 5 4 0] with: continue!

controlSetDocName: string
	"@message void MSG_PRINT_CONTROL_SET_DOC_NAME( char *string = cx:dx )"
	^self geosMessage: #[108 3 2 53 3 0] with: string!

controlReportProgress: progress with: pageOrPercent
	"@message Boolean MSG_PRINT_CONTROL_REPORT_PROGRESS( PCProgressType progress = cx, word pageOrPercent = dx )"
	^self geosMessage: #[108 4 2 53 1 1 4] with: progress with: pageOrPercent!

controlReportString: progress with: progressString
	"@message Boolean MSG_PRINT_CONTROL_REPORT_STRING( PCProgressType progress = cx, char *progressString = dx:bp )"
	^self geosMessage: #[108 4 3 245 1 3 4] with: progress with: progressString!

controlPrintingCancelled
	"@message void MSG_PRINT_CONTROL_PRINTING_CANCELLED()"
	^self geosMessage: #[108 5 2 0 0]!

controlPrintingCompleted
	"@message void MSG_PRINT_CONTROL_PRINTING_COMPLETED()"
	^self geosMessage: #[108 6 2 0 0]!

controlSetAttrs: attributes
	"@message void MSG_PRINT_CONTROL_SET_ATTRS( PrintControlAttrs attributes = cx )"
	^self geosMessage: #[108 7 2 5 1 0] with: attributes!

controlGetAttrs
	"@message PrintControlAttrs MSG_PRINT_CONTROL_GET_ATTRS()= cx"
	^self geosMessage: #[108 8 102 0 1]!

controlSetTotalPageRange: firstPage with: lastPage
	"@message void MSG_PRINT_CONTROL_SET_TOTAL_PAGE_RANGE( word firstPage = cx, word lastPage = dx )"
	^self geosMessage: #[108 9 2 53 1 1 0] with: firstPage with: lastPage!

controlGetTotalPageRange
	"@message PCPageRange MSG_PRINT_CONTROL_GET_TOTAL_PAGE_RANGE()= cx.dx"
	^self geosMessage: #[108 10 154 0 2]!

controlSetSelectedPageRange: firstPage with: lastPage
	"@message void MSG_PRINT_CONTROL_SET_SELECTED_PAGE_RANGE(word firstPage = cx, word lastPage = dx )"
	^self geosMessage: #[108 11 2 53 1 1 0] with: firstPage with: lastPage!

controlGetSelectedPageRange
	"@message PCPageRange MSG_PRINT_CONTROL_GET_SELECTED_PAGE_RANGE()= cx.dx"
	^self geosMessage: #[108 12 154 0 2]!

controlSetDocSize: width with: height
	"@message void MSG_PRINT_CONTROL_SET_DOC_SIZE(word width = cx, word height = dx)"
	^self geosMessage: #[108 13 2 53 1 1 0] with: width with: height!

controlGetDocSize
	"@message SizeAsDWord MSG_PRINT_CONTROL_GET_DOC_SIZE()= dx.cx"
	^self geosMessage: #[108 14 166 0 2]!

controlSetExtendedDocSize: ptr
	"@message void MSG_PRINT_CONTROL_SET_EXTENDED_DOC_SIZE( PCDocSizeParams *ptr = dx:bp )"
	^self geosMessage: #[108 15 2 62 3 0] with: ptr!

controlGetExtendedDocSize: ptr
	"@message void MSG_PRINT_CONTROL_GET_EXTENDED_DOC_SIZE( PCDocSizeParams *ptr = dx:bp )"
	^self geosMessage: #[108 16 2 62 3 0] with: ptr!

controlSetDocMargins: ptr
	"@message void MSG_PRINT_CONTROL_SET_DOC_MARGINS( PCMarginParams *ptr = dx:bp )"
	^self geosMessage: #[108 17 2 62 3 0] with: ptr!

controlGetDocMargins: ptr
	"@message void MSG_PRINT_CONTROL_GET_DOC_MARGINS( PCMarginParams *ptr = dx:bp )"
	^self geosMessage: #[108 18 2 62 3 0] with: ptr!

controlSetDocSizeInfo: ptr
	"@message void MSG_PRINT_CONTROL_SET_DOC_SIZE_INFO(PageSizeReport *ptr = dx:bp)"
	^self geosMessage: #[108 19 2 62 3 0] with: ptr!

controlGetDocSizeInfo: ptr
	"@message void MSG_PRINT_CONTROL_GET_DOC_SIZE_INFO(PageSizeReport *ptr = dx:bp)"
	^self geosMessage: #[108 20 2 62 3 0] with: ptr!

controlSetOutput: objectPtr
	"@message void MSG_PRINT_CONTROL_SET_OUTPUT( optr objectPtr = cx:dx )"
	^self geosMessage: #[108 21 2 53 2 0] with: objectPtr!

controlGetOutput
	"@message optr MSG_PRINT_CONTROL_GET_OUTPUT()= cx:dx"
	^self geosMessage: #[108 22 154 0 2]!

controlSetDocNameOutput: document
	"@message void MSG_PRINT_CONTROL_SET_DOC_NAME_OUTPUT( optr document = cx:dx )"
	^self geosMessage: #[108 23 2 53 2 0] with: document!

controlGetDocNameOutput
	"@message optr MSG_PRINT_CONTROL_GET_DOC_NAME_OUTPUT()= cx:dx"
	^self geosMessage: #[108 24 154 0 2]!

controlSetDefaultPrinter: printerNum
	"@message void MSG_PRINT_CONTROL_SET_DEFAULT_PRINTER( word printerNum = cx )"
	^self geosMessage: #[108 25 2 5 1 0] with: printerNum!

controlGetDefaultPrinter
	"@message word MSG_PRINT_CONTROL_GET_DEFAULT_PRINTER()= cx"
	^self geosMessage: #[108 26 102 0 1]!

controlGetPrintMode
	"@message PrinterMode MSG_PRINT_CONTROL_GET_PRINT_MODE()= cl"
	^self geosMessage: #[108 27 74 0 1]!

controlGetPaperSizeInfo: ptr
	"@message void MSG_PRINT_CONTROL_GET_PAPER_SIZE_INFO( PageSizeReport *ptr = dx:bp)"
	^self geosMessage: #[108 28 2 62 3 0] with: ptr!

controlGetPaperSize: retValue
	"@message void MSG_PRINT_CONTROL_GET_PAPER_SIZE( PaperDimensions *retValue = axcxdxbp)"
	^self geosMessage: #[108 29 198 0 3 0] with: retValue!

controlGetPrinterMargins: retValue with: setMargins
	"@message void MSG_PRINT_CONTROL_GET_PRINTER_MARGINS( PCMarginParams *retValue = axcxdxbp, Boolean setMargins = dx)"
	^self geosMessage: #[108 30 198 6 3 4 0] with: retValue with: setMargins!

controlCalcDocDimensions: ptr
	"@message void MSG_PRINT_CONTROL_CALC_DOC_DIMENSIONS( PageSizeReport *ptr = dx:bp)"
	^self geosMessage: #[108 31 2 62 3 0] with: ptr!

controlCheckIfDocWillFit: warning
	"@message Boolean MSG_PRINT_CONTROL_CHECK_IF_DOC_WILL_FIT(Boolean warning = cx)"
	^self geosMessage: #[108 32 2 5 4 4] with: warning!

controlVerifyPrint
	"@message void MSG_PRINT_CONTROL_VERIFY_PRINT()"
	^self geosMessage: #[108 33 2 0 0]!

controlVerifyScale
	"@message void MSG_PRINT_CONTROL_VERIFY_SCALE()"
	^self geosMessage: #[108 34 2 0 0]!

controlVerifyCancel
	"@message void MSG_PRINT_CONTROL_VERIFY_CANCEL()"
	^self geosMessage: #[108 35 2 0 0]!

controlAbortPrintJob
	"@message void MSG_PRINT_CONTROL_ABORT_PRINT_JOB()"
	^self geosMessage: #[108 36 2 0 0]!

controlInitiateOutputUi: type
	"@message void MSG_PRINT_CONTROL_INITIATE_OUTPUT_UI(PrinterDriverType type = cl)"
	^self geosMessage: #[108 37 2 1 1 0] with: type!

setPrintControlPageSize: psr
	"@message void MSG_PRINT_SET_PRINT_CONTROL_PAGE_SIZE(PageSizeReport *psr = dx:bp)"
	^self geosMessage: #[108 38 2 62 3 0] with: psr!

getMailboxObjectType: dataType
	"@message Boolean MSG_PRINT_GET_MAILBOX_OBJECT_TYPE(word *dataType = multipleax)= carry"
	^self geosMessage: #[108 39 214 0 3 4] with: dataType!

cannotPrint: error
	"@message void MSG_PRINT_CANNOT_PRINT(word error = cx)"
	^self geosMessage: #[108 40 2 5 1 0] with: error!

getFirstPageOffset
	"@message word MSG_PRINT_GET_FIRST_PAGE_OFFSET()= dx"
	^self geosMessage: #[108 41 106 0 1]!

setPrintHeaderOption: state
	"@message word MSG_PRINT_SET_PRINT_HEADER_OPTION(FoamPrintHeaderState state = cx)"
	^self geosMessage: #[108 42 2 5 1 1] with: state!

!

